#pragma once

#include <library/cpp/json/json_value.h>
#include <library/cpp/uri/uri.h>

#include <util/datetime/base.h>
#include <util/generic/hash_set.h>

#include <optional>

struct TBeacon {
    NUri::TUri Url;
    TString ServerIp;
    TDuration Age;
    ui64 Weight;
    TString LegacyStatus;

    TBeacon(const NJson::TJsonValue& beacon);

    static TVector<TString> AllLegacyStatuses();

private:
    static TString ErrorToLegacyStatus(TStringBuf error);

private:
    const static THashSet<TString> KnownErrors_;
};

