#pragma once

#include "stats_collector.h"
#include "logs_collector.h"

#include <library/cpp/http/server/http.h>

#include <util/generic/buffer.h>

class TCollectorRequestReplier;

class TCollectorServer: public THttpServer, public THttpServer::ICallBack {
public:
    TCollectorServer(TStatsCollector* sc, TLogsCollector* lc, const THttpServer::TOptions& opts)
        : THttpServer(this, opts)
        , StatsCollector(sc)
        , LogsCollector(lc)
    { }

private:
    TClientRequest* CreateClient() override;

    void OnException() override;

public:
    TStatsCollector* const StatsCollector;
    TLogsCollector* const LogsCollector;
};

class TCollectorRequestReplier: public TRequestReplier {
public:
    TCollectorRequestReplier(TCollectorServer* srv)
        : Server_(srv)
    { }

private:
    bool DoReply(const TReplyParams& params) override;

    bool ReadBody(THttpInput& input);

private:
    TCollectorServer* Server_;
    TBuffer Body_;
    const size_t MaxInputSize_ = 128 * 1024;
};
