#pragma once

#include "beacon.h"
#include "stats_buffer.h"
#include "solomon_stats_slices_config.h"

#include <geobase/include/lookup.hpp>

#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/hash_set.h>

#include <optional>

class TSolomonStats {
public:
    TSolomonStats();

    void CountBeacon(const TBeacon& beacon, std::optional<NGeobase::NImpl::StrList> clientASNList);

    TDuration Interval() const { return StatsBuffer_.Interval; };
    const TSolomonStatsSlicesConfig& SlicesConfig() const { return Config_; };
    const TStatsBuffer& StatsBuffer() const { return StatsBuffer_; };

private:

private:
    TSolomonStatsSlicesConfig Config_;
    TStatsBuffer StatsBuffer_;
};
