#pragma once

#include <util/generic/vector.h>
#include <util/generic/hash.h>
#include <util/generic/hash_set.h>

#include <tuple>

struct TSolomonStatsSlice {
    const TString HostSubslice;
    const TString Status;
    const TString ASN;

    std::tuple<TString, TString, TString> MakeTuple() const {
        return std::make_tuple(HostSubslice, Status, ASN);
    }
    bool operator==(const TSolomonStatsSlice& b) const {
        return MakeTuple() == b.MakeTuple();
    }
};

template<>
struct THash<TSolomonStatsSlice> {
    size_t operator()(const TSolomonStatsSlice& slice) {
        return THash<std::tuple<TString, TString, TString>>()
            (slice.MakeTuple());
    }
};

class TSolomonStatsSlicesConfig {
public:
    struct THostSubsliceConfig {
        TString Name;
        THashSet<TString> IPs;
    };

    struct THostSubslicesConfig {
        TVector<THostSubsliceConfig> Slices;
        TString DefaultSlice;
    };

    TSolomonStatsSlicesConfig();

private:
    static TVector<TString> MakeHostSubslices();
    static TVector<TSolomonStatsSlice> MakeSlices();

public:
    static const THashSet<TString> WatchedSchemes;
    static const THashMap<TString, THostSubslicesConfig> WatchedHosts;
    static const THashSet<TString> WatchedASNs;
    static const TString DefaultASN;

    const TVector<TSolomonStatsSlice> Slices;
    const THashMap<TSolomonStatsSlice, size_t> IdxBySlice;
};
