#pragma once

#include "yasm_stats.h"
#include "solomon_stats.h"

#include <geobase/include/lookup.hpp>

#include <library/cpp/http/misc/httpreqdata.h>

#include <optional>

class TStatsCollector {
public:
    TStatsCollector(std::optional<TString> geodataPath = std::nullopt);

    void CollectRequest(TStringBuf body, const TServerRequestData& reqData);
    void CollectRequestTcpInfo(TStringBuf body, const TServerRequestData& reqData);

    const TYasmStats& YasmStats() { return YasmStats_; };
    const TSolomonStats& SolomonStats() { return SolomonStats_; };

private:
    std::optional<NGeobase::NImpl::StrList> ExtractASNList(TStringBuf clientIp);

private:
    TYasmStats YasmStats_;
    TSolomonStats SolomonStats_;

    std::optional<NGeobase::NImpl::TLookup> GeobaseLookup_;
};
