#include "stats_collector.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TStatsCollectorTest) {
    Y_UNIT_TEST(CountSimpleBeaconTest) {
        const TString simpleBeacon = "{\"entries\":[{\"failure_data\":{\"custom_error\":\"net::ERR_ABORTED\"},\"network_changed\":false,\"protocol\":\"\",\"request_age_ms\":61251,\"request_elapsed_ms\":12,\"sample_rate\":1.0,\"server_ip\":\"\",\"status\":\"aborted\",\"url\":\"https://an.yandex.ru/\",\"was_proxied\":false},{\"http_response_code\":404,\"network_changed\":false,\"protocol\":\"SPDY\",\"request_age_ms\":47860,\"request_elapsed_ms\":314,\"sample_rate\":1.0,\"server_ip\":\"77.88.21.90:443\",\"status\":\"http.error\",\"url\":\"https://an.yandex.ru/\",\"was_proxied\":false}],\"reporter\":\"chrome\"}";
        const TString yasmSignal = "https_an.yandex.ru_error_net_err_aborted_summ";

        TStatsCollector collector;
        UNIT_ASSERT_VALUES_EQUAL(collector.YasmStats().Stats().at(yasmSignal), 0);

        collector.CollectRequest(simpleBeacon, TServerRequestData());
        UNIT_ASSERT_VALUES_EQUAL(collector.YasmStats().Stats().at(yasmSignal), 1);
    }

    Y_UNIT_TEST(CountTCPInfoBeaconTest) {
        const TString simpleBeacon = "2058 {\"method\":\"GET\",\"request\":\"/images-apphost/duck?docid=79266cde8e6469e238d55f3ad05570bf&count=5&lang=ru&text=%D1%83%D0%B3%D0%BB%D0%BE%D0%B2%D1%8B%D0%B5%20%D1%88%D0%BA%D0%B0%D1%84%D1%8B%20%D0%BD%D0%B0%D0%B4%20%D0%BE%D0%B1%D0%B5%D0%B4%D0%B5%D0%BD%D0%BD%D1%8B%D0%BC%20%D1%81%D1%82%D0%BE%D0%BB%D0%BE%D0%BC\",\"protocol\":\"HTTP/1.1\",\"addr\":\"89.109.8.101:26436\",\"headers\":[[\"X-Yandex-TCP-Info\",\"v=2; rtt=0.030951s; rttvar=0.018316s; snd_cwnd=206; total_retrans=0\"],[\"X-Req-Id\",\"1584618904638831-9873638200648332703\"],[\"user-agent\",\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 YaBrowser/20.3.0.1217 Yowser/2.5 Safari/537.36\"],[\"X-Yandex-RandomUID\",\"8483327031584618904\"],[\"cookie\",\"yandexuid=9561379681580190725; yuidss=9561379681580190725; _ym_uid=1580190792782280564; mda=0; my=YwA=; font_loaded=YSv1; ymex=1896268413.yrts.1580908413; _ym_uid=1580190792782280564; _ym_d=1583411871; yandex_gid=20041; zm=m-white_bender.webp.css-https%3As3home-static_d9zkTHoy-CWxx3RttlJSGtk7c-c%3Al; i=rB2AWSA4Y3WzPAWdFJQ5wMVTsfF16QB0LwwDwZfp2BIsOdCeJlauq6l+j9GggB1fXHqh4WJcv6FdIwBtqorFfz4GF/s=; gdpr=0; _ym_isad=2; _ym_d=1584593174; yc=1584852864.zen.cach%3A1584596689; cycada=g05SGeUa3HTrjU0lVATTH27a3W+vzHyfh86YcfBJoYU=; yabs-frequency=/4/0G0G05XSSru-INDU/7A0_RKWw8HsWFsr8EY4wtd9mI3eXK84-RKWw9tpoFMr0EYTwyZrjG3edU_8zRJmw9oPki719EW01/; yp=1612444414.cld.2270452#1612444414.brd.0401003145#1586406883.ygu.1#1600361093.szm.1:1280x1024:1232x884#1615877059.p_sw.1584341058#1611815903.p_cl.1580279903#1586865348.nps.12675028%3Aclose#1615370570.stltp.serp_bk-map_1_1583834570#1584852291.clh.2270456#1899782336.sad.1584422336%3A1584422336%3A1#1588310337.hks.0#1584625747.gpauto.56_644821%3A43_472351%3A100000%3A3%3A1584618547#1584680808.ln_tp.01; ys=def_bro.1#svt.1#ybzcc.ru#wprid.1584618601115212-569471978384685017700136-sas4-3065#mclid.2270456\"],[\"X-Forwarded-For\",\"89.109.8.101\"],[\"host\",\"yandex.ru\"],[\"X-Forwarded-For-Y\",\"89.109.8.101\"]],\"hdrs_len\":2300,\"timestamp\":1584618904,\"backend_errors\":0,\"status\":200,\"resptime_us\":5413}";
        const TString yasmSignal = "rtt_total_received_summ";

        TStatsCollector collector;
        UNIT_ASSERT_VALUES_EQUAL(collector.YasmStats().Stats().at(yasmSignal), 0);
        collector.CollectRequestTcpInfo(simpleBeacon, TServerRequestData());
        UNIT_ASSERT_VALUES_EQUAL(collector.YasmStats().Stats().at(yasmSignal), 1);
    }
};
