#pragma once

#include "yasm_stats.h"
#include "solomon_stats.h"

#include <library/cpp/http/server/http.h>

class TCollectorRequestReplier;

class TStatsServer: public THttpServer, public THttpServer::ICallBack {
public:
    TStatsServer(const TYasmStats* ys, const TSolomonStats* ss, const THttpServer::TOptions& opts)
        : THttpServer(this, opts)
        , YasmStats(ys)
        , SolomonStats(ss)
    { }

private:
    TClientRequest* CreateClient() override;

    void OnException() override;

public:
    const TYasmStats* const YasmStats;
    const TSolomonStats* const SolomonStats;
};

class TStatsRequestReplier: public TRequestReplier {
public:
    TStatsRequestReplier(TStatsServer* srv)
        : Server_(srv)
    { }

private:
    bool DoReply(const TReplyParams& params) override;

    void WriteYasmStats(THttpOutput& out);
    void WriteSolomonStats(THttpOutput& out, TInstant solomonNow, TDuration solomonPeriod);

private:
    TStatsServer* const Server_;
};
