#pragma once

#include "beacon.h"
#include "tcpinfo.h"

#include <geobase/include/lookup.hpp>

#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <library/cpp/deprecated/atomic/atomic.h>

#include <optional>

class TYasmStats {
public:
    using TStats = THashMap<TString, TAtomic>;

    TYasmStats();

    void CountBeacon(const TBeacon& beacon, std::optional<NGeobase::NImpl::StrList> clientASNList);
    void CountTcpInfo(const TTcpInfo& tcpInfo, std::optional<NGeobase::NImpl::StrList> clientASNList);

    const TStats& Stats() const { return Stats_; };

private:
    TString MakeSignalName(TStringBuf scheme, TStringBuf host, TStringBuf status);
    TString MakeASNSignalName(TStringBuf asn, TStringBuf hostType, TStringBuf status);
    TString MakeTcpInfoRttSignalName(TStringBuf asn);
    TString MakeTcpInfoTotalSignalName();
    TString MakeTcpInfoTotalPassedSignalName();

private:
    const THashSet<TString> WatchedSchemes_;
    const THashMap<TString, TString> WatchedHosts_;
    const THashSet<TString> WatchedASNs_;
    const TDuration MaxAcceptedAge_;

    TStats Stats_;
};
