#pragma once

#include "server_base.h"

#include <library/cpp/http/server/http.h>


class TAdminServer: public TNeldrlogServerBase {
public:
    typedef std::function<void()> TCallback;

    TAdminServer(
        const THttpServer::TOptions& opts,
        TCallback onShutdown,
        TCallback onReopenlog
    )
        : TNeldrlogServerBase(opts)
        , OnShutdown(onShutdown)
        , OnReopenlog(onReopenlog)
    { }

private:
    TClientRequest* CreateClient() override;

public:
    const TCallback OnShutdown;
    const TCallback OnReopenlog;
};


class TAdminRequestReplier: public TNeldrlogRequestReplierBase {
public:
    explicit TAdminRequestReplier(TAdminServer* srv)
        : Server_(srv)
    { }

private:
    bool DoReply(const TReplyParams& params) override;

private:
    TAdminServer* const Server_;
};

