# pragma once

#include <library/cpp/regex/pire/pire.h>

#include <yaml-cpp/yaml.h>
#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/system/types.h>


enum EHandlePurpose {
    NEL,
    UNISTAT,
    SOLOMON,
};


struct THandleInfo {
    const EHandlePurpose Purpose;
    const TString TenantName;

    THandleInfo(const EHandlePurpose purpose, const TString tenantName)
        : Purpose(purpose)
        , TenantName(tenantName)
    { }
};


struct TTenantConfiguration { 
    bool FullErrorTypes;

    THashSet<TString>* ASNs;

    NPire::TNonrelocScanner SitesRegex;
    TVector<TString> Sites;
};


class TConfiguration {
public:
    ui16 NELPort;
    ui16 StatsPort;
    ui16 AdminPort;

    // Access log contains requests to neldrlog;
    // A request may consist of several NEL reports.
    bool WriteAccessLog;
    TString AccessLogFilePath;  
    // Report log contains individual NEL reports.
    bool WriteReportLog;
    TString ReportLogFilePath; 

    TString GeodataFilePath;

    TDuration MaxReportAge;

    THashMap<TString, TTenantConfiguration> Tenants;
    // handle -> purpose and tenant
    THashMap<TString, THandleInfo> Handles;

private:
    THashMap<TString, THashSet<TString>> ASNGroups_;

public:
    bool ReadFromYAMLFile(const TString& filePath);
    bool ReadFromYAMLString(const std::string& configuration);

private:
    bool ReadFromYAMLRootNode(const YAML::Node& root);
};

