#pragma once

#include <library/cpp/http/misc/httpreqdata.h>
#include <library/cpp/logger/file.h>

#include <util/generic/string.h>

#include "configuration.h"
#include "nel_report.h"


class TLogger {
public:
    TLogger(
        const TConfiguration& configuration,
        size_t queueSize
    );

    void LogRequest(
        const TString& tenant,
        TStringBuf body,
        const TServerRequestData& reqData
    );

    void LogReport(
        const TString& tenant,
        TNELReport& report
    );

    void ReopenLog();

private:
    const TConfiguration& Configuration_;
    THolder<TLogBackend> RequestLog_;
    THolder<TLogBackend> ReportLog_;
};

