#pragma once

#include <geobase/include/lookup.hpp>

#include <library/cpp/http/misc/httpreqdata.h>
#include <library/cpp/json/json_value.h>
#include <library/cpp/uri/uri.h>

#include <util/datetime/base.h>
#include <util/generic/hash_set.h>

#include <optional>


class TNELReportSender {
public:
    TStringBuf NeldrlogPath;

    TStringBuf IP;
    TVector<TString> ASNs;

    TStringBuf UserAgent;
    TStringBuf OSFamily;
    TStringBuf BrowserName;
    bool IsMobile;

public:
    TNELReportSender() {}
    TNELReportSender(
        const TServerRequestData& requestData,
        const std::optional<NGeobase::NImpl::TLookup>& geobaseLookup
    );

private:
    void FillASNs(
        const TStringBuf clientIp,
        const std::optional<NGeobase::NImpl::TLookup>& geobaseLookup
    );

    void FillUATraits(const TStringBuf UserAgent);
};

struct TNELReport {
    NUri::TUri Url;
    TString ServerIP;
    int StatusCode;

    TDuration Age;
    TString NELErrorType;
    TString GroupedErrorType;
    TString FullErrorType;

    TNELReportSender& Sender;

    explicit TNELReport(TNELReportSender& sender)
        : Sender(sender)
    { }
    TNELReport(TNELReportSender& sender, const NJson::TJsonValue& reportJson);
};

const THashSet<TString>& GetNeldrlogErrorTypes(bool extended);

