#pragma once

#include "metric_storage.h"
#include "logger.h"
#include "server_base.h"

#include <library/cpp/http/misc/parsed_request.h>
#include <library/cpp/http/server/http.h>

#include <util/generic/buffer.h>


class TNELServer: public TNeldrlogServerBase {
public:
    TNELServer(
        const THttpServer::TOptions& httpServerOptions,
        const TConfiguration& configuration,
        TMetricStorage& metricStorage,
        TLogger& logger
    )
        : TNeldrlogServerBase(httpServerOptions)
        , Configuration_(configuration)
        , MetricStorage_(metricStorage)
        , Logger_(logger)
        , GeobaseLookup_(configuration.GeodataFilePath)
    { }

private:
    TClientRequest* CreateClient() override;

private:
    const TConfiguration& Configuration_;
    TMetricStorage& MetricStorage_;
    TLogger& Logger_;
    const std::optional<NGeobase::NImpl::TLookup> GeobaseLookup_;
};


class TNELServerRequestReplier: public TNeldrlogRequestReplierBase {
public:
    TNELServerRequestReplier(
        const TConfiguration& configuration,
        TMetricStorage& metricStorage,
        TLogger& logger,
        const std::optional<NGeobase::NImpl::TLookup>& geobaseLookup
    )
        : Configuration_(configuration)
        , MetricStorage_(metricStorage)
        , Logger_(logger)
        , GeobaseLookup_(geobaseLookup)
    { }

private:
    bool DoReply(const TReplyParams& replyParams) override;
    bool ReadBody(TBuffer& body, THttpInput& input);

private:
    static const size_t MaxBodySize_ = 128 * 1024;

    const TConfiguration& Configuration_;
    TMetricStorage& MetricStorage_;
    TLogger& Logger_;
    const std::optional<NGeobase::NImpl::TLookup>& GeobaseLookup_;
};

