#include "server_base.h"


void TNeldrlogServerBase::OnException() {
    Cerr << Now().ToStringLocal() << ' '
         << CurrentExceptionMessage()
         << '\n';
}

void TNeldrlogRequestReplierBase::FillRequestData(
    TServerRequestData& requestData,
    TParsedHttpFull& request,
    const TReplyParams& replyParams
) {
    if (!requestData.Parse(TString(request.Request).data())) {
        ythrow yexception() << "couldn't parse the Request-Line";
    }
    requestData.Scan();
    for (auto& h : replyParams.Input.Headers()) {
        requestData.AddHeader(h.Name(), h.Value());
    }
}

