#pragma once

#include "metric_storage.h"
#include "server_base.h"

#include <library/cpp/http/server/http.h>


class TStatsServer : public TNeldrlogServerBase {
public:
    TStatsServer(
        const THttpServer::TOptions& httpServerOptions,
        const TConfiguration& configuration,
        const TMetricStorage& metricStorage
    )
        : TNeldrlogServerBase(httpServerOptions)
        , Configuration_(configuration)
        , MetricStorage_(metricStorage)
    { }

private:
    TClientRequest* CreateClient() override;

private:
    const TConfiguration& Configuration_;
    const TMetricStorage& MetricStorage_;
};


class TStatsServerRequestReplier : public TNeldrlogRequestReplierBase {
public:
    explicit TStatsServerRequestReplier(const TConfiguration& configuration, const TMetricStorage& metricStorage)
        : Configuration_(configuration)
        , MetricStorage_(metricStorage)
    { }

private:
    bool DoReply(const TReplyParams& replyParams) override;

    EMetricWriteFormat FindMetricWriteFormat(const THandleInfo& handle, const TServerRequestData& requestData);

private:
    const TConfiguration& Configuration_;
    const TMetricStorage& MetricStorage_;
};

