#include <library/cpp/json/json_reader.h>
#include <library/cpp/resource/resource.h>
#include <library/cpp/testing/unittest/registar.h>

#include <balancer/drlogger_nel/library/nel_report.h>


Y_UNIT_TEST_SUITE(TNELReportTest) {

    Y_UNIT_TEST(ReadFromJson) {
        NJson::TJsonValue json;
        UNIT_ASSERT_NO_EXCEPTION(NJson::ReadJsonTree(NResource::Find("nel_report.json"), &json, true));
        
        TNELReportSender sender;
        TNELReport report(sender, json);
        UNIT_ASSERT_STRINGS_EQUAL(report.Url.GetHost(), "yandex.ru");
        UNIT_ASSERT_STRINGS_EQUAL(report.GroupedErrorType, "http_error");
        UNIT_ASSERT_STRINGS_EQUAL(report.FullErrorType, "http_protocol_error");
    }

}

