#include "algorithm.h"

namespace NSrvKernel {

void TBackendsGroupWeights::Add(double weight, size_t index) {
    Y_ENSURE(weight >= 0);
    WeightsSum += weight;
    BoundaryAndIndex.emplace_back(WeightsSum, index);
}

void TBackendsGroupWeights::Clear() noexcept {
    WeightsSum = 0;
    BoundaryAndIndex.clear();
}

} // namespace NSrvKernel
