#include <balancer/kernel/balancer/ut_mocks/algorithm_mock.h>
#include <balancer/kernel/balancer/ut_mocks/backend_mock.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel;

using ::testing::Return;
using ::testing::Ref;

Y_UNIT_TEST_SUITE(TBasicUnittest) {
    constexpr TDuration DUR_SAMPLE = TDuration::MicroSeconds(5);

    Y_UNIT_TEST(AlgorithmMockTest) {
        NSrvKernel::NTesting::TAlgorithmPartMock am;

        EXPECT_CALL(am, Next())
            .Times(1)
            .WillOnce(Return(nullptr));

        auto* bd = am.SelectNext();
        UNIT_ASSERT_EQUAL(bd, nullptr);
    }

    Y_UNIT_TEST(BackendMockTest) {
        NSrvKernel::NTesting::TPerWorkerBackendMock bm(MakeHolder<TBackendDescriptor>("", nullptr));

        EXPECT_CALL(bm, DoOnCompleteRequest(DUR_SAMPLE))
            .Times(1);

        bm.OnCompleteRequest(DUR_SAMPLE);

        TError error = Y_MAKE_ERROR(yexception{} << "test");
        EXPECT_CALL(bm, DoOnFailRequest(Ref(error), DUR_SAMPLE))
            .Times(1);

        bm.OnFailRequest(error, DUR_SAMPLE);
    }
}
