#pragma once

#include <balancer/kernel/balancer/algorithm.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NSrvKernel::NTesting {

class TAlgorithmPartMock : public IAlgorithm {
public:
    TAlgorithmPartMock() : IAlgorithm(nullptr) {}
    MOCK_METHOD(void, RemoveSelected, (IBackend*), (override));
    MOCK_METHOD(void, Reset, (), (override));

    MOCK_METHOD(IBackend*, Next, (), (override));
};

class TAlgorithmMock : public TAlgorithmPartMock {
public:
    MOCK_METHOD(void, Select, (IBackend*), (override));
    MOCK_METHOD(IBackend*, SelectNext, (), (override));

    MOCK_METHOD(IBackend*, NextByName, (TStringBuf, bool), (override));
    MOCK_METHOD(IBackend*, NextByHash, (IHashProcessor&), (override));
};

}  // namespace NSrvKernel::NTesting
