#include "blacklist.h"

namespace NSrvKernel::NDynamicBalancing {

TIntrusivePtr<TBlacklist> TBlacklist::Parse(TStringBuf content) noexcept {
    auto blacklist = MakeIntrusive<TBlacklist>();
    TStringBuf line;
    while (content.ReadLine(line)) {
        if (!line.empty()) {
            blacklist->Add(TString(line));
        }
    }

    // parse last line without \n
    if (!content.empty()) {
        blacklist->Add(TString(content));
    }

    return blacklist;
}

}
