#pragma once

#include <util/generic/ptr.h>
#include <util/generic/hash_set.h>

namespace NSrvKernel::NDynamicBalancing {

class TBlacklist : public TThrRefBase {
public:
    static TIntrusivePtr<TBlacklist> Parse(TStringBuf content) noexcept;

    bool Contains(TStringBuf name) const noexcept {
        return Blacklisted_.contains(name);
    }

    void Add(TString name) noexcept {
        Blacklisted_.emplace(std::move(name));
    }

    bool Empty() const noexcept {
        return Blacklisted_.empty();
    }

private:
    THashSet<TString> Blacklisted_;
};

}
