#pragma once

#include <balancer/kernel/log/log.h>
#include <library/cpp/logger/log.h>
#include <util/datetime/base.h>

namespace NSrvKernel::NDynamicBalancing {
    class TDynamicLog {
    public:
        TDynamicLog(TString name)
            : Name_(std::move(name))
        {
            if (Name_.empty()) {
                Name_ = "(empty)";
            }
        }

        void SetLog(TLog* log) {
            Parent_ = log;
        }

        void SetName(TString name) {
            Name_ = std::move(name);
        }

        template <class T>
        TLogElement operator<<(const T& t) {
            TLogElement e{Parent_ ? Parent_ : &NullLog_};
            e << Now().ToStringLocal() << "\t[" << Name_ << "]\t" << t;
            return e;
        }

    private:
        TLog* Parent_ = nullptr;
        TLog NullLog_;
        TString Name_;
    };

}
