#include "common.h"

#include <balancer/kernel/balancing/pessimization.h>
#include <balancer/kernel/balancing/updater.h>
#include <library/cpp/testing/unittest/registar.h>
#include <util/string/builder.h>

using namespace NSrvKernel::NDynamicBalancing;

Y_UNIT_TEST_SUITE(BlacklistFileParsing) {
    Y_UNIT_TEST(EmptyBlacklistFileParsing) {
        {
            auto blacklist = TBlacklist::Parse("");
            UNIT_ASSERT(blacklist->Empty());
        }

        {
            auto blacklist = TBlacklist::Parse("\n\n\n\n\n\n\n\n\n");
            UNIT_ASSERT(blacklist->Empty());
        }
    }

    Y_UNIT_TEST(LastBlacklistFileLineIsParsed) {
        auto blacklist = TBlacklist::Parse("first");
        UNIT_ASSERT(!blacklist->Empty());
        UNIT_ASSERT(blacklist->Contains("first"));
    }

    Y_UNIT_TEST(AllBlacklistFileLinesAreParsed) {
        TStringBuilder content;
        for (size_t i = 0; i < 100; i++) {
            content << Endl;
            content << ToString(i) << Endl;
            content << Endl;
        }
        content << Endl;
        content << Endl;
        auto blacklist = TBlacklist::Parse(content);
        UNIT_ASSERT(!blacklist->Empty());
        for (size_t i = 0; i < 100; i++) {
            UNIT_ASSERT(blacklist->Contains(ToString(i)));
        }
    }
}
