#include "client_hints_face.h"

#include <util/generic/singleton.h>
#include <util/string/strip.h>

namespace NSrvKernel {
    void SetUARestore(THolder<IUARestorer> uaRestorer) {
        GetUARestorer().Reset(uaRestorer);
    }

    NUATraits::THintsHeaders GetHintsHeaders(const THeaders& headers) noexcept {
        NUATraits::THintsHeaders hintsHeaders{
                StripString(headers.GetFirstValue("Sec-CH-UA")),
                StripString(headers.GetFirstValue("Sec-CH-UA-Arch")),
                StripString(headers.GetFirstValue("Sec-CH-UA-Full-Version")),
                StripString(headers.GetFirstValue("Sec-CH-UA-Mobile")),
                StripString(headers.GetFirstValue("Sec-CH-UA-Model")),
                StripString(headers.GetFirstValue("Sec-CH-UA-Platform")),
                StripString(headers.GetFirstValue("Sec-CH-UA-Platform-Version")),
                StripString(headers.GetFirstValue("Sec-CH-UA-Bitness"))
        };

        return hintsHeaders;
    }

    TStringBuf GetUAHeader(const THeaders& headers) noexcept {
        return StripString(headers.GetFirstValue("User-Agent"));
    }

    THolder<IUARestorer>& GetUARestorer() noexcept {
        return *Singleton<THolder<IUARestorer>>();
    }
}
