#pragma once

#include <balancer/kernel/helpers/errors.h>
#include <balancer/kernel/http/headers.h>

#include <metrika/core/libs/uahints/UAHintsHeaders.h>

#include <util/generic/fwd.h>
#include <util/generic/maybe.h>

namespace NSrvKernel {
    struct TUATraits {
        bool SameSiteNoneSupport = false;
    };

    struct TUAAndUATraits {
        TMaybe<TString> RestoredUA;
        TMaybe<TString> SerializedUATraits;
    };

    class IUARestorer {
    public:
        virtual ~IUARestorer() {}

        virtual void Init(bool buildUAFromHints, bool buildProto) = 0;
        virtual TErrorOr<TUAAndUATraits> GetUAAndUATraits(
                const NUATraits::THintsHeaders& hints,
                TStringBuf oldUserAgent) noexcept = 0;
    };

    void SetUARestore(THolder<IUARestorer> uaRestorer);

    NUATraits::THintsHeaders GetHintsHeaders(const THeaders& headers) noexcept;

    TStringBuf GetUAHeader(const THeaders& headers) noexcept;

    THolder<IUARestorer>& GetUARestorer() noexcept;
}
