#pragma once

#include <balancer/kernel/client_hints/client_hints_face.h>

#include <balancer/kernel/helpers/errors.h>
#include <balancer/kernel/http/headers.h>

#include <metrika/core/libs/uahints/UserAgentTraits.h>

namespace NSrvKernel {
    class TConnDescr;

    class TUARestorerImpl
        : public IUARestorer
    {
    public:
        void Init(bool buildUAFromHints, bool buildProto) noexcept override;
        TErrorOr<TUAAndUATraits> GetUAAndUATraits(
                const NUATraits::THintsHeaders& hints,
                TStringBuf oldUserAgent) noexcept override;

    private:
        NUATraits::IUserAgentTraitsPtr<> UATraits_;
    };

    class TCachedUATraits
    {
    public:
        TCachedUATraits() noexcept;
        TUATraits GetUATraits(const TStringBuf uaHeader) noexcept;
        TUATraits GetOrSetUATraits(const TConnDescr& descr) noexcept;

    private:
        NUATraits::IUserAgentTraitsPtr<TUATraits> UATraits_;
    };

    TCachedUATraits& GetCachedUATraits() noexcept;

    TUATraits GetUATraits(const TStringBuf uaHeader) noexcept;
    TUATraits GetOrSetUATraits(const TConnDescr& descr) noexcept;
}
