#include "balancer/kernel/client_hints/client_hints_face.h"
#include <balancer/kernel/client_hints/impl/client_hints.h>

#include <balancer/kernel/http/headers.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel;

bool CmpStructs(const TUAAndUATraits& left, const TUAAndUATraits& right) {
    return (((left.RestoredUA.Empty() && right.RestoredUA.Empty()) || *left.RestoredUA == *right.RestoredUA)
        && ((left.SerializedUATraits.Empty() && right.SerializedUATraits.Empty()) || *left.SerializedUATraits == *right.SerializedUATraits));
};

void MakeTestUARestore(const TUAAndUATraits& expected, const THeaders& headers) {
    auto hintsHeaders = GetHintsHeaders(headers);
    auto uaHeader = GetUAHeader(headers);

    TUAAndUATraits result;
    auto error = GetUARestorer()->GetUAAndUATraits(hintsHeaders, uaHeader).AssignTo(result);

    UNIT_ASSERT(
        CmpStructs(expected, result)
    );
}

Y_UNIT_TEST_SUITE(TClientHintsTest) {
        Y_UNIT_TEST(TestEmptyGet) {
            SetUARestore(MakeHolder<TUARestorerImpl>());
            GetUARestorer()->Init(true, true);

            THeaders empty_headers;

            auto expected = TUAAndUATraits{{},{}};

            MakeTestUARestore(expected, empty_headers);
        }

        Y_UNIT_TEST(TestChromeGet) {
            SetUARestore(MakeHolder<TUARestorerImpl>());
            GetUARestorer()->Init(true, true);

            THeaders headers;
            headers.Add("sec-ch-ua", "\" Not;A Brand\";v=\"99\", \"Google Chrome\";v=\"91\","
                    " \"Chromium\";v=\"91\"");
            headers.Add("sec-ch-ua-mobile", "?0");

            auto expected = TUAAndUATraits{
                "Mozilla/5.0 ( ; ) AppleWebKit/537.36 (KHTML, like Gecko)"
                "  Not;A Brand/99 Chrome/91 Chrome/91  Safari/537.36",
                TString{
                    "\x1A\x06\x57\x65\x62\x4B"
                    "\x69\x74\x22\x06\x43\x68"
                    "\x72\x6F\x6D\x65\x32\x08"
                    "\x43\x68\x72\x6F\x6D\x69"
                    "\x75\x6D\x62\x04\x00\x00"
                    "\x00\x00\x6A\x04\x00\x00"
                    "\x00\x00\x72\x04\x00\x00"
                    "\x00\x00\x7A\x04\x00\x00"
                    "\x00\x00\x82\x01\x04\x00"
                    "\x00\x00\x00\x8A\x01\x04"
                    "\x00\x00\x00\x00\x92\x01"
                    "\x04\x00\x00\x00\x00\x9A"
                    "\x01\x04\x00\x00\x00\x00"
                    "\xA2\x01\x04\x00\x00\x00"
                    "\x00\xAA\x01\x04\x00\x00\x00\x00",
                    92
                }
            };

            MakeTestUARestore(expected, headers);
        }
}
