#include <balancer/kernel/client_hints/impl/client_hints.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TUATraitsTest) {
    Y_UNIT_TEST(TestGet) {
        using namespace NSrvKernel;

        UNIT_ASSERT(GetUATraits(
            "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko)"
            " Ubuntu Chromium/76.0.3770.90 Chrome/76.0.3770.90 Safari/537.36").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko)"
            " Chrome/75.0.3770.142 Safari/537.36").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko)"
            " Chrome/76.0.3729.169 YaBrowser/19.9.2.594 (beta) Yowser/2.5 Safari/537.36").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:68.0)"
            " Gecko/20100101 Firefox/68.0").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_2) AppleWebKit/604.0.12 (KHTML, like Gecko)"
            " Version/10.1 Safari/600.1.13").SameSiteNoneSupport);

        UNIT_ASSERT(GetUATraits(
            "Mozilla/5.0 (Linux; Android 6.0; M5 Note) AppleWebKit/537.36 (KHTML, like Gecko)"
            " Chrome/77.0.3770.143 Mobile Safari/537.36").SameSiteNoneSupport);

        UNIT_ASSERT(GetUATraits(
            "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko)"
            " Ubuntu Chromium/80.0.3987.87 Chrome/80.0.3987.87 Safari/537.36").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (Linux; Android 6.0; M5 Note) AppleWebKit/537.36 (KHTML, like Gecko)"
            " Chrome/74.0.3729.169 YaBrowser/19.6.4.349.00 Mobile Safari/537.36").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (Android 6.0; Mobile; rv:68.0)"
            " Gecko/68.0 Firefox/68.0").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko)"
            " Version/12.0 YaBrowser/19.9.2.561.10 Mobile/15E148 Safari/605.1").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko)"
            " CriOS/76.0.3729.121 Mobile/15E148 Safari/605.1").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko)"
            " Version/12.0 YaBrowser/19.8.2.561.10 Mobile/15E148 Safari/605.1").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko)"
            " CriOS/75.0.3729.121 Mobile/15E148 Safari/605.1").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko)"
            " Mobile/15E148").SameSiteNoneSupport);

        UNIT_ASSERT(!GetUATraits(
            "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko)"
            " Version/12.1 Mobile/15E148 Safari/604.1").SameSiteNoneSupport);
    }
}
