#pragma once

#include <balancer/kernel/helpers/errors.h>

#include <util/generic/ptr.h>

namespace NSrvKernel {
    class TConnDescr;
    struct THostInfo;

    class TBackendProtocols;

    class IClientRequest
        : public TAtomicRefCount<IClientRequest> {
    public:
        virtual ~IClientRequest() = default;

        NSrvKernel::TError Run(const TConnDescr& conn, const TBackendProtocols& backend, const THostInfo& hostInfo) noexcept {
            return DoRun(conn, backend, hostInfo);
        }
    private:
        virtual NSrvKernel::TError DoRun(const TConnDescr& conn, const TBackendProtocols& backend, const THostInfo& hostInfo) noexcept = 0;
    };

    using IClientRequestRef = TIntrusivePtr<IClientRequest>;
}
