#include <library/cpp/testing/unittest/registar.h>

#include <balancer/kernel/client_request/backend.h>
#include <balancer/kernel/client_request/backend_config.h>

using namespace NSrvKernel;

Y_UNIT_TEST_SUITE(TestBackendProtocol) {
    Y_UNIT_TEST(Simple) {
        class TBackendA
            : public TBackendProtocolImpl<TBackendA>
        {
        public:
            TBackendA(const TBackendConfig&) {}

            static const TStringBuf ProtocolName() {
                return "A";
            }
        };

        class TBackendB
            : public TBackendProtocolImpl<TBackendB>
        {
        public:
            TBackendB(const TBackendConfig&) {}

            static const TStringBuf ProtocolName() {
                return "B";
            }
        };

        class TBackendC
            : public TBackendProtocolImpl<TBackendC>
        {
        public:
            TBackendC(const TBackendConfig&) {}

            static const TStringBuf ProtocolName() {
                return "C";
            }
        };

        TBackendProtocolFactory factory;
        factory.RegisterProtocolImpl<TBackendA>();
        factory.RegisterProtocolImpl<TBackendB>();

        TBackendProtocols backend;
        TBackendConfig options;
        backend.AddImpl(factory, "A", options);
        backend.AddImpl(factory, "B", options);

        try {
            backend.AddImpl(factory, "C", options);
            UNIT_ASSERT(false);
        } catch (...) {}

        UNIT_ASSERT(backend.GetImpl<TBackendA>());
        UNIT_ASSERT(backend.GetImpl<TBackendB>());
        UNIT_ASSERT(!backend.GetImpl<TBackendC>());
    }
}

