#pragma once

#include <balancer/kernel/module/conn_descr.h>

#include <util/generic/vector.h>
#include <util/network/address.h>
#include <util/random/shuffle.h>

namespace NModProxy {
    using namespace NSrvKernel;

    using TAddrVec = TVector<const TSockAddr*>;

    TAddrVec FilterAddr(const TSockAddrInfo& addr, int family) noexcept;

    void ShuffleAddr(TAddrVec& addr) noexcept;

    TErrorOr<const TSockAddr*> Connect(TContExecutor* const exec, TSocketHolder& s, const TAddrVec& addrs, int type,
                        int protocol, const TInstant deadLine, TConnStats& stats) noexcept;
}
