#include <balancer/kernel/cookie/deletion/delete_cookie.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel;

Y_UNIT_TEST_SUITE(TCookieDeletionTest) {
    Y_UNIT_TEST(TestParentPath) {
        UNIT_ASSERT_VALUES_EQUAL(ParentPath("/aa/bb/"), "/aa/bb");
        UNIT_ASSERT_VALUES_EQUAL(ParentPath("/aa/bb"), "/aa/");
        UNIT_ASSERT_VALUES_EQUAL(ParentPath("/aa/"), "/aa");
        UNIT_ASSERT_VALUES_EQUAL(ParentPath("/aa/"), "/aa");
        UNIT_ASSERT_VALUES_EQUAL(ParentPath("/aa"), "/");
        UNIT_ASSERT_VALUES_EQUAL(ParentPath("/"), "/");
        UNIT_ASSERT_VALUES_EQUAL(ParentPath("/a//"), "/a/");
        UNIT_ASSERT_VALUES_EQUAL(ParentPath("//"), "/");
        UNIT_ASSERT_VALUES_EQUAL(ParentPath(""), "");
    }

    Y_UNIT_TEST(TestDeleteLocal) {
        for (auto sec : {false, true}) {
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieLocal({
                .Name="a", .Path="/abc", .Host="yandex.ru", .Secure=sec,
            }), (TSetCookie{
                .Name="a", .Path="/abc", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,
            }));
        }
    }

    Y_UNIT_TEST(TestDeleteEveryPath) {
        for (auto sec : {false, true}) {
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryPath({
                .Name="a", .Path="/", .Host="yandex.ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryPath({
                .Name="a", .Path="/", .Host="yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{}));

            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryPath({
                .Name="a", .Host="yandex.ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryPath({
                .Name="a", .Host="yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));

            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryPath({
                .Name="a", .Path="///", .Host="yandex.ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="//", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="///", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryPath({
                .Name="a", .Path="///", .Host="yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="//", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="///", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));

            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryPath({
                .Name="a", .Path="/a/b/", .Host="yandex.ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryPath({
                .Name="a", .Path="/a/b/", .Host="yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));

            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryPath({
                .Name="a", .Path="/a/b", .Host="yandex.ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryPath({
                .Name="a", .Path="/a/b", .Host="yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
        }
    }

    Y_UNIT_TEST(TestDeleteEveryDomain) {
        for (auto sec : {false, true}) {
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/", .Host="yandex.ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/a", .Host="yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/a", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/", .Host="yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));

            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/a", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/a", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));

            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/", .Host="127.0.0.1", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/a", .Host="127.0.0.1", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/a", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/", .Host="127.0.0.1", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));

            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/", .Host="ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/a", .Host="ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/a", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/", .Host="ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));

            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/", .Host="www.yandex.ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/a", .Host="www.yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/a", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomain({
                .Name="a", .Path="/", .Host="www.yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
        }
    }

    Y_UNIT_TEST(TestDeleteEveryDomainPath) {
        for (auto sec : {false, true}) {
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomainPath({
                .Name="a", .Path="/a/b/", .Host="yandex.ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomainPath({
                .Name="a", .Path="/a/b/", .Host="yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));

            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomainPath({
                .Name="a", .Path="/", .Host="www.yandex.ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomainPath({
                .Name="a", .Path="/", .Host="www.yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));

            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomainPath({
                .Name="a", .Path="/a/b/", .Host="www.yandex.ru", .Secure=sec,
            }, false), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
            UNIT_ASSERT_VALUES_EQUAL(DeleteCookieEveryDomainPath({
                .Name="a", .Path="/a/b/", .Host="www.yandex.ru", .Secure=sec,
            }, true), (TVector<TSetCookie>{
                {.Name="a", .Path="/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Domain=".www.yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
                {.Name="a", .Path="/a/b/", .Domain=".yandex.ru", .Expires=TExpires::Past(), .MaxAge=0, .Secure=sec,},
            }));
        }
    }
}
