#pragma once

#include <balancer/kernel/cookie/utils/utils.h>

#include <util/generic/maybe.h>
#include <util/generic/strbuf.h>

#include <string>

namespace NSrvKernel {
    TMaybe<TStringBuf> ShortestPrivateSuffix(TStringBuf validDomainNameLowerCase) noexcept;

    TMaybe<TStringBuf> LongestPublicSuffix(TStringBuf validDomainLowerCase) noexcept;

    // Strips port, returns nothing if a domain name is invalid
    bool ValidDomainName(TStringBuf domainStr) noexcept;

    bool NoCookieDomain(TStringBuf domainStr) noexcept;

    // EU ccTlds, all gTlds, non-EU ccTlds used as gTlds, all IDNs except ccIDNs of the non-EU ex-USSR countries.
    // Intended to be used as a fallback guess when nothing else is known about the gdpr status of the request.
    bool GdprDomain(TStringBuf domainStr) noexcept;

    // Substitutes the public suffix for .TLD Returns Nothing if invalid.
    TMaybe<std::string> ReplacePublicSuffix(TStringBuf domainLowerCase, TStringBuf wcard=TStringBuf("TLD")) noexcept;

    void InitDomains();

}
