#include <balancer/kernel/cookie/utils/utils.h>
#include <balancer/kernel/cookie/domain/domain.h>

extern "C" int LLVMFuzzerTestOneInput(const ui8* const wireData, const size_t wireSize) {
    using namespace NSrvKernel;

    auto inp = TStringBuf{(const char*) (wireData), wireSize};
    auto res = ShortestPrivateSuffix(inp);

    if (res) {
        if (*res) {
            Y_ENSURE(ShortestPrivateSuffix(*res) == *res);
            Y_ENSURE(LongestPublicSuffix(*res) == res->After('.'));
        } else {
            Y_ENSURE(LongestPublicSuffix(inp) == NCookie::SkipDot(inp));
        }
    } else {
        Y_ENSURE(!LongestPublicSuffix(inp));
    }

    return 0;
}
