#include <balancer/kernel/cookie/domain/domain.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel;

Y_UNIT_TEST_SUITE(TCookieDomainTest) {
    Y_UNIT_TEST(TestDomainName) {
        UNIT_ASSERT(ValidDomainName("yandex"));
        // Does not strip a leading dot
        UNIT_ASSERT(!ValidDomainName(".yandex"));
        UNIT_ASSERT(ValidDomainName("YANDEX"));
        UNIT_ASSERT(ValidDomainName("yandex."));
        UNIT_ASSERT(ValidDomainName("yandex.ru"));
        // Does not strip port
        UNIT_ASSERT(!ValidDomainName("yandex.ru:8080"));
        UNIT_ASSERT(ValidDomainName("a"));
        UNIT_ASSERT(ValidDomainName("a1"));
        UNIT_ASSERT(ValidDomainName("xn--fiqs8s"));
        // Does not convert idns
        UNIT_ASSERT(!ValidDomainName("中国"));
        // Does not allow ip addresses
        UNIT_ASSERT(!ValidDomainName("::"));
        UNIT_ASSERT(!ValidDomainName("2a02::0"));
        UNIT_ASSERT(!ValidDomainName("127.0.0.1"));
        UNIT_ASSERT(!ValidDomainName("1"));
    }

    Y_UNIT_TEST(TestGdprTld) {
        UNIT_ASSERT(GdprDomain("com"));
        UNIT_ASSERT(GdprDomain("com."));
        UNIT_ASSERT(GdprDomain("yandex"));
        UNIT_ASSERT(GdprDomain("yandex."));
        UNIT_ASSERT(GdprDomain("www.yandex"));
        UNIT_ASSERT(GdprDomain("www.yandex."));
        UNIT_ASSERT(GdprDomain("yandex.com"));
        UNIT_ASSERT(GdprDomain("Yandex.Com"));
        UNIT_ASSERT(GdprDomain("yandex.com."));
        UNIT_ASSERT(GdprDomain("yandex.eu"));
        UNIT_ASSERT(GdprDomain("a.yandex.eu"));
        UNIT_ASSERT(GdprDomain("a.b.yandex.eu"));
        UNIT_ASSERT(GdprDomain("market.yandex.eu"));
        UNIT_ASSERT(GdprDomain("yandex.fr"));
        UNIT_ASSERT(GdprDomain("yandex.fi"));
        UNIT_ASSERT(GdprDomain("yandex.xn--qxam"));
        UNIT_ASSERT(GdprDomain("yandex.xn--90ae"));
        UNIT_ASSERT(GdprDomain("yandex.st"));
        UNIT_ASSERT(GdprDomain("yandex.io"));
        UNIT_ASSERT(GdprDomain("yandex.cc"));
        UNIT_ASSERT(GdprDomain("yandex.me"));
        UNIT_ASSERT(GdprDomain("yandex.tm"));

        UNIT_ASSERT(!GdprDomain("yandex.com.ua"));
        UNIT_ASSERT(!GdprDomain("yandex.ru"));
        UNIT_ASSERT(!GdprDomain("yandex.xn--p1ai"));
        UNIT_ASSERT(!GdprDomain("yandex.xn--j1amh"));
        UNIT_ASSERT(!GdprDomain("yandex.xn--80aswg"));
        UNIT_ASSERT(!GdprDomain("yandex.moscow"));
    }

    Y_UNIT_TEST(TestNoCookieDomain) {
        UNIT_ASSERT(NoCookieDomain("yandex.net"));
        UNIT_ASSERT(NoCookieDomain("yandex.net."));
        UNIT_ASSERT(NoCookieDomain("qloud.yandex.net"));
        UNIT_ASSERT(NoCookieDomain("qloud.yandex.net."));
    }

    Y_UNIT_TEST(TestReplacePublicSuffix) {
        UNIT_ASSERT_VALUES_EQUAL(ReplacePublicSuffix("a.."), Nothing());
        UNIT_ASSERT_VALUES_EQUAL(ReplacePublicSuffix("yandex.ru"), "yandex.TLD");
        UNIT_ASSERT_VALUES_EQUAL(ReplacePublicSuffix("yandex.ru."), "yandex.TLD");
        UNIT_ASSERT_VALUES_EQUAL(ReplacePublicSuffix(".yandex.ru"), ".yandex.TLD");
        UNIT_ASSERT_VALUES_EQUAL(ReplacePublicSuffix("ru"), "TLD");
        UNIT_ASSERT_VALUES_EQUAL(ReplacePublicSuffix("yandex"), "TLD");
        UNIT_ASSERT_VALUES_EQUAL(ReplacePublicSuffix("market.yandex"), "market.TLD");
        UNIT_ASSERT_VALUES_EQUAL(ReplacePublicSuffix("market.yandex.com.tr"), "market.yandex.TLD");
    }
}
