#include <balancer/kernel/cookie/set_cookie.h>

extern "C" int LLVMFuzzerTestOneInput(const ui8* const wireData, const size_t wireSize) {
    using namespace NSrvKernel;
    auto c = TSetCookie::Parse(NCookie::FromStringBuf({(const char*)wireData, wireSize}));
    if (std::holds_alternative<TSetCookie>(c)) {
        auto b = std::get<TSetCookie>(c).Render();
        auto c2 = TSetCookie::Parse(b);
        Y_ENSURE(std::holds_alternative<TSetCookie>(c2));
        Y_ENSURE(std::get<TSetCookie>(c2) == std::get<TSetCookie>(c));
        auto b2 = std::get<TSetCookie>(c2).Render();
        Y_ENSURE(NCookie::ToStringBuf(b2) == NCookie::ToStringBuf(b));
    }
    return 0;
}
