#pragma once

#include <util/generic/maybe.h>

#include <balancer/kernel/helpers/helper_macro.h>

namespace NGdprCookie {

    enum class EGdpr {
        KeepAll             /* "0", "KeepAll" */,
        KeepTech            /* "1", "KeepTech" */,
        KeepTechAnalytic    /* "2", "KeepTechAnalytic" */,
        KeepTechOther       /* "3", "KeepTechOther" */,
    };

    enum class EIsGdpr : ui32 {
        False = 0   /* "0" */,
        True        /* "1" */,
    };


    struct TGdpr {
        struct TVal {
            EGdpr Mode = EGdpr::KeepAll;
            bool IsGdpr = false;
        public:
            Y_BALANCER_TUPLE_EQ(TVal, Mode, IsGdpr)
        };
        // When unsure guessed in favour of gdpr. See cookie_policy for details.
        // Use this to deside on nondestructive actions, e.g. whether to reduce the set-cookie lifetime.
        TVal Value;
        // When unsure guessed against gdpr. See cookie_policy for details.
        // Use this to deside on highly destructive actions, e.g. deleting all the client cookies.
        TVal SafeValue;

    public:
        Y_BALANCER_TUPLE_EQ(TGdpr, Value, SafeValue)
    };


    struct TXIpProperties {
        bool IsGdpr = false;
        bool IsVpn = false;
    public:
        Y_BALANCER_TUPLE_EQ(TXIpProperties, IsGdpr, IsVpn)
    };


    struct TGdprCache {
        TMaybe<TXIpProperties> XIpProperties;
        TMaybe<bool> XYandexEURequest;

    public:
        Y_BALANCER_TUPLE_EQ(TGdprCache, XIpProperties, XYandexEURequest)
    };
}

const TString& ToString(NGdprCookie::EGdpr);
const TString& ToString(NGdprCookie::EIsGdpr);
