#pragma once

#include "gdpr.h"

#include <util/generic/maybe.h>
#include <util/generic/strbuf.h>

namespace NGdprCookie {
    enum class ECookieType {
        Tech        /* "tech", "session" */,
        Analytic    /* "analytic" */,
        Other       /* "other" */,
    };

    [[nodiscard]]
    bool KeepCookie(ECookieType cookieType, EGdpr gdpr) noexcept;

    void InitCookieRegistry(bool detectConflicts);

    [[nodiscard]]
    ECookieType CookieType(TStringBuf name) noexcept;

    class TCookie;

    [[nodiscard]]
    const TCookie& CookieDescr(TStringBuf name) noexcept;
}
