#pragma once

#include "common/gdpr.h"

namespace NGdprCookie {
    constexpr TStringBuf GdprCookie = "gdpr";
    constexpr TStringBuf GdprPopupCookie = "gdpr_popup";
    constexpr TStringBuf IsGdprCookie = "is_gdpr";
    constexpr TStringBuf IsGdprBCookie = "is_gdpr_b";

    [[nodiscard]]
    TMaybe<EGdpr> ParseGdprCookie(TStringBuf) noexcept;
    [[nodiscard]]
    TStringBuf RenderGdprCookie(EGdpr) noexcept;
    [[nodiscard]]
    EGdpr MergeGdprCookie(EGdpr prev, EGdpr next) noexcept;

    // Parses both is_gdpr and x-yandex-eu-request

    [[nodiscard]]
    TMaybe<EIsGdpr> ParseIsGdprCookie(TStringBuf) noexcept;
    [[nodiscard]]
    TStringBuf RenderIsGdprCookie(EIsGdpr) noexcept;
    [[nodiscard]]
    EIsGdpr MergeIsGdprCookie(EIsGdpr prev, EIsGdpr next) noexcept;
}

const TString& ToString(NGdprCookie::EGdpr);
const TString& ToString(NGdprCookie::EIsGdpr);
