#pragma once

#include <balancer/kernel/cookie/utils/utils.h>

#include <library/cpp/json/writer/json.h>
#include <util/datetime/base.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NGdprCookie {
    // An important part of the is_gdpr_b binary format. Do not change.
    constexpr auto IsGdprBStart = TInstant::Seconds(1599598800);

    struct [[nodiscard]] TIsGdprB {
        ui32 BalancerVerHash = 0;
        TInstant Tstamp;
        bool IsGdpr = false;
        TMaybe<bool> IsGdprNoVpn;

    public:
        Y_BALANCER_TUPLE_EQ(
            TIsGdprB,
            BalancerVerHash,
            Tstamp,
            IsGdpr,
            IsGdprNoVpn
        )

        [[nodiscard]]
        bool Same(const TMaybe<TIsGdprB>& other) const noexcept {
            return other && IsGdpr == other->IsGdpr && IsGdprNoVpn == other->IsGdprNoVpn;
        }

        [[nodiscard]]
        TString Render() const noexcept;

        [[nodiscard]]
        static TMaybe<TIsGdprB> Parse(TStringBuf rawBase64) noexcept;

        static TIsGdprB Merge(TIsGdprB prev, TIsGdprB next) noexcept;
    };

    [[nodiscard]]
    ui32 BalancerVerHash(TStringBuf branch, TStringBuf lastChange) noexcept;

    [[nodiscard]]
    ui32 BalancerVerHash() noexcept;
}
