#include "lifetime.h"

#include <util/thread/singleton.h>

namespace NGdprCookie {

    i64 LimitLifetime(i64 maxAge) noexcept {
        return std::min<i64>(maxAge, MaxAllowedAge.Seconds());
    }

    TDuration LimitLifetime(TDuration lifetime) noexcept {
        return std::min(lifetime, MaxAllowedAge);
    }

    TExpires LimitLifetime(TInstant now, TExpires expires) noexcept {
        return std::min(expires, TMaxAllowedExpires::Get(now));
    }

}
