#pragma once

#include <balancer/kernel/cookie/expires.h>

#include <util/datetime/base.h>

namespace NGdprCookie {

    using NSrvKernel::TExpires;
    using NSrvKernel::TExpiresGlobalCache;

    // Approx. 2 years
    constexpr TDuration MaxAllowedAge = TDuration::Seconds(2 * 365 * 24 * 60 * 60);
    using TMaxAllowedExpires = TExpiresGlobalCache<MaxAllowedAge.Seconds()>;

    [[nodiscard]]
    i64 LimitLifetime(i64 maxAge) noexcept;

    [[nodiscard]]
    TDuration LimitLifetime(TDuration lifetime) noexcept;

    [[nodiscard]]
    TExpires LimitLifetime(TInstant now, TExpires expires) noexcept;

}
