#include <balancer/kernel/cookie/gdpr/is_gdpr_b.h>

#include <util/stream/input.h>
#include <util/stream/output.h>

int main() {
    TString line;
    while (Cin.ReadLine(line)) {
        StripInPlace(line);
        if (!line) {
            continue;
        }
        if (auto msg = NGdprCookie::TIsGdprB::Parse(line)) {
            Cout << line << "\t"
                << "{\"BalancerVerHash\":" << msg->BalancerVerHash
                << ",\"Tstamp\":" << msg->Tstamp.Seconds()
                << ",\"IsGdpr\":" << msg->IsGdpr;
            if (msg->IsGdprNoVpn) {
                Cout << ",\"IsGdprNoVpn\":" << *msg->IsGdprNoVpn;
            }
            Cout << "}" << Endl;
        } else {
            Cout << line << "\tnull" << Endl;
        }
    }
}
