#include <balancer/kernel/cookie/gdpr/cookie_type.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/serialized_enum.h>

using namespace NGdprCookie;

Y_UNIT_TEST_SUITE(TGdprCookieTypeTest) {
    template <class T, class C>
    auto ToVector(C&& c) {
        return TVector<T>(c.begin(), c.end());
    }

    Y_UNIT_TEST(TestKeepCookie) {
        UNIT_ASSERT_VALUES_EQUAL(ToVector<ECookieType>(GetEnumAllValues<ECookieType>()), (TVector<ECookieType>{
            ECookieType::Tech,
            ECookieType::Analytic,
            ECookieType::Other
        }));
        UNIT_ASSERT_VALUES_EQUAL(ToVector<EGdpr>(GetEnumAllValues<EGdpr>()), (TVector<EGdpr>{
            EGdpr::KeepAll,
            EGdpr::KeepTech,
            EGdpr::KeepTechAnalytic,
            EGdpr::KeepTechOther
        }));

        for (auto m : GetEnumAllValues<EGdpr>()) {
            UNIT_ASSERT_C(KeepCookie(ECookieType::Tech, m), m);
        }

        for (const auto& [m, t, k] : std::initializer_list<std::tuple<EGdpr, ECookieType, bool>>{
            {EGdpr::KeepTechAnalytic, ECookieType::Analytic, true},
            {EGdpr::KeepTechAnalytic, ECookieType::Other, false},
            {EGdpr::KeepTechOther, ECookieType::Analytic, false},
            {EGdpr::KeepTechOther, ECookieType::Other, true},
        }) {
            UNIT_ASSERT_VALUES_EQUAL_C(KeepCookie(t, m), k, m << " " << t);
        }
    }
}
