#include <balancer/kernel/cookie/gdpr/gdpr.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/serialized_enum.h>

using namespace NGdprCookie;

Y_UNIT_TEST_SUITE(TGdprCookieTest) {
    Y_UNIT_TEST(TestGdprRender) {
        UNIT_ASSERT_VALUES_EQUAL(RenderGdprCookie(EGdpr::KeepAll), "0");
        UNIT_ASSERT_VALUES_EQUAL(RenderGdprCookie(EGdpr::KeepTech), "1");
        UNIT_ASSERT_VALUES_EQUAL(RenderGdprCookie(EGdpr::KeepTechAnalytic), "2");
        UNIT_ASSERT_VALUES_EQUAL(RenderGdprCookie(EGdpr::KeepTechOther), "3");
    }

    Y_UNIT_TEST(TestGdprParse) {
        UNIT_ASSERT_VALUES_EQUAL(ParseGdprCookie("0"), EGdpr::KeepAll);
        UNIT_ASSERT_VALUES_EQUAL(ParseGdprCookie("1"), EGdpr::KeepTech);
        UNIT_ASSERT_VALUES_EQUAL(ParseGdprCookie("2"), EGdpr::KeepTechAnalytic);
        UNIT_ASSERT_VALUES_EQUAL(ParseGdprCookie("3"), EGdpr::KeepTechOther);
        UNIT_ASSERT_VALUES_EQUAL(ParseGdprCookie("4"), Nothing());
    }

    Y_UNIT_TEST(TestGdprMerge) {
        for (auto v : GetEnumAllValues<EGdpr>()) {
            UNIT_ASSERT_VALUES_EQUAL(MergeGdprCookie(EGdpr::KeepAll, v), EGdpr::KeepAll);
            UNIT_ASSERT_VALUES_EQUAL(MergeGdprCookie(v, EGdpr::KeepAll), EGdpr::KeepAll);
            UNIT_ASSERT_VALUES_EQUAL(MergeGdprCookie(v, v), v);
        }
        UNIT_ASSERT_VALUES_EQUAL(
            MergeGdprCookie(EGdpr::KeepTechOther, EGdpr::KeepTechAnalytic),
            EGdpr::KeepTechOther
        );
        UNIT_ASSERT_VALUES_EQUAL(
            MergeGdprCookie(EGdpr::KeepTechAnalytic, EGdpr::KeepTechOther),
            EGdpr::KeepTechOther
        );
        UNIT_ASSERT_VALUES_EQUAL(
            MergeGdprCookie(EGdpr::KeepTechOther, EGdpr::KeepTech),
            EGdpr::KeepTechOther
        );
        UNIT_ASSERT_VALUES_EQUAL(
            MergeGdprCookie(EGdpr::KeepTech, EGdpr::KeepTechOther),
            EGdpr::KeepTechOther
        );
        UNIT_ASSERT_VALUES_EQUAL(
            MergeGdprCookie(EGdpr::KeepTechAnalytic, EGdpr::KeepTech),
            EGdpr::KeepTechAnalytic
        );
        UNIT_ASSERT_VALUES_EQUAL(
            MergeGdprCookie(EGdpr::KeepTech, EGdpr::KeepTechAnalytic),
            EGdpr::KeepTechAnalytic
        );
    }

    Y_UNIT_TEST(TestIsGdprRender) {
        UNIT_ASSERT_VALUES_EQUAL(RenderIsGdprCookie(EIsGdpr::False), "0");
        UNIT_ASSERT_VALUES_EQUAL(RenderIsGdprCookie(EIsGdpr::True), "1");
    }

    Y_UNIT_TEST(TestIsGdprParse) {
        UNIT_ASSERT_VALUES_EQUAL(ParseIsGdprCookie("0"), EIsGdpr::False);
        UNIT_ASSERT_VALUES_EQUAL(ParseIsGdprCookie("1"), EIsGdpr::True);
        UNIT_ASSERT_VALUES_EQUAL(ParseIsGdprCookie("2"), Nothing());
    }

    Y_UNIT_TEST(TestIsGdprMerge) {
        UNIT_ASSERT_VALUES_EQUAL(MergeIsGdprCookie(EIsGdpr::False, EIsGdpr::True), EIsGdpr::False);
        UNIT_ASSERT_VALUES_EQUAL(MergeIsGdprCookie(EIsGdpr::True, EIsGdpr::False), EIsGdpr::False);
        UNIT_ASSERT_VALUES_EQUAL(MergeIsGdprCookie(EIsGdpr::False, EIsGdpr::False), EIsGdpr::False);
        UNIT_ASSERT_VALUES_EQUAL(MergeIsGdprCookie(EIsGdpr::True, EIsGdpr::True), EIsGdpr::True);
    }
}
