#include <balancer/kernel/cookie/gdpr/is_gdpr_b.pb.h>
#include <balancer/kernel/cookie/gdpr/is_gdpr_b.h>

#include <library/cpp/string_utils/base64/base64.h>
#include <library/cpp/svnversion/svnversion.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/digest/city.h>

#include <util/generic/serialized_enum.h>

using namespace NGdprCookie;

Y_UNIT_TEST_SUITE(TIsGdprBTest) {
    Y_UNIT_TEST(TestParseRender) {
        TIsGdprB c;
        c.BalancerVerHash = 123;
        c.Tstamp = TInstant::Hours(444357);
        {
            auto cc = TIsGdprB::Parse(c.Render());
            UNIT_ASSERT_VALUES_EQUAL(cc, c);
            UNIT_ASSERT(!cc->IsGdprNoVpn);
        }
        c.IsGdpr = true;
        c.IsGdprNoVpn = true;
        {
            auto cc = TIsGdprB::Parse(c.Render());
            UNIT_ASSERT_VALUES_EQUAL(cc, c);
            UNIT_ASSERT(cc->IsGdprNoVpn);
            UNIT_ASSERT(*cc->IsGdprNoVpn);
        }
        c.IsGdpr = false;
        c.IsGdprNoVpn = false;
        {
            auto cc = TIsGdprB::Parse(c.Render());
            UNIT_ASSERT_VALUES_EQUAL(cc, c);
            UNIT_ASSERT(cc->IsGdprNoVpn);
            UNIT_ASSERT(!*cc->IsGdprNoVpn);
        }
    }

    Y_UNIT_TEST(TestMerge) {
        UNIT_ASSERT_VALUES_EQUAL(
            TIsGdprB::Merge({.Tstamp=TInstant::Hours(444356)}, {.Tstamp=TInstant::Hours(444358)}),
            (TIsGdprB{.Tstamp=TInstant::Hours(444358)})
        );
    }

    Y_UNIT_TEST(TestVerHash) {
        if (TStringBuf(GetTag()).size()) {
            UNIT_ASSERT_VALUES_EQUAL(BalancerVerHash(), 0x1FFFFF & CityHash64(TString(GetTag())));
        } else {
            UNIT_ASSERT_VALUES_EQUAL(
                BalancerVerHash(), 0x1FFFFF & CityHash64(TString::Join(GetBranch(), "@", GetArcadiaLastChange())));
        }
    }
}
