#include <balancer/kernel/cookie/gdpr/lifetime.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NGdprCookie;

Y_UNIT_TEST_SUITE(TGdprCookieLifetimeTest) {
    Y_UNIT_TEST(TestLimitLifetime) {
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(MaxAllowedAge.Seconds() - 1), MaxAllowedAge.Seconds() - 1);
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(MaxAllowedAge.Seconds() + 1), MaxAllowedAge.Seconds());
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(Min<i64>()), Min<i64>());
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(Max<i64>()), MaxAllowedAge.Seconds());

        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(MaxAllowedAge - TDuration::Seconds(1)),
            MaxAllowedAge - TDuration::Seconds(1));
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(MaxAllowedAge + TDuration::Seconds(1)),
            MaxAllowedAge);
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(TDuration::Max()), MaxAllowedAge);
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(TDuration()), TDuration());

        TInstant now = Now();
        auto before = *TExpires::FromInstant(now + (MaxAllowedAge - TDuration::Seconds(1)));
        auto during = *TExpires::FromInstant(now + MaxAllowedAge);
        auto after = *TExpires::FromInstant(now + (MaxAllowedAge + TDuration::Seconds(1)));
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(now, before), before);
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(now, after), during);
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(now, TExpires::Max()), during);
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(now, *TExpires::FromInstant(now)), *TExpires::FromInstant(now));
        UNIT_ASSERT_VALUES_EQUAL(LimitLifetime(now, TExpires::Min()), TExpires::Min());
    }
}
