#pragma once

#include "cookie.h"
#include "expires.h"
#include "cookie_errors.h"

#include <util/generic/maybe.h>
#include <util/generic/variant.h>
#include <util/memory/blob.h>

#include <string>
#include <tuple>

namespace NSrvKernel {

    constexpr TStringBuf CookiePrefixHostOnly = "__Host-";
    constexpr TStringBuf CookiePrefixSecureOnly = "__Secure-";

    enum class ESameSite : ui32 {
        // not a real value
        Undefined = 0,
        None,
        Lax,
        Strict,
    };


    class [[nodiscard]] TSetCookie {
    public:
        using TParseResult = std::variant<TSetCookie, TSetCookieSyntaxErrors>;

        [[nodiscard]]
        size_t RenderMaxSz() const noexcept;

        [[nodiscard]]
        TBlob Render(bool singleThreadedResult = true) const noexcept;

        [[nodiscard]]
        static TParseResult Parse(TBlob setCookie) noexcept;

        Y_BALANCER_TUPLE_EQ(
            TSetCookie,
            TStringBuf(Name),
            NCookie::ToStringBuf(Value),
            TStringBuf(Path),
            TStringBuf(Domain),
            Expires,
            MaxAge,
            SameSite,
            Secure,
            HttpOnly
        )

    public:
        std::string Name;
        TBlob Value;

        std::string Path;
        std::string Domain;

        TMaybeExpires Expires;
        TMaybe<ui32> MaxAge;
        ESameSite SameSite = ESameSite::Undefined;

        bool Secure = false;
        bool HttpOnly = false;
    };

    [[nodiscard]]
    bool HasDeletion(const TSetCookie& c, TInstant now) noexcept;
}
