#include <library/cpp/testing/unittest/registar.h>

#include <balancer/kernel/cookie/obfuscation.h>

using namespace NSrvKernel;

Y_UNIT_TEST_SUITE(TTestCookieMeta) {
    void DoTestPrintSetCookieMeta(TStringBuf cookie, TStringBuf expected) {
        using namespace NSrvKernel;
        UNIT_ASSERT_VALUES_EQUAL_C(ObfuscateSetCookieValue(cookie), expected, TString{cookie}.Quote());
    }

    Y_UNIT_TEST(TestCookieMeta) {
        DoTestPrintSetCookieMeta("", "");
        DoTestPrintSetCookieMeta(" ", "");
        DoTestPrintSetCookieMeta(" a; ", "a;");
        DoTestPrintSetCookieMeta("a ;", "a ;");
        DoTestPrintSetCookieMeta("a", "a");
        DoTestPrintSetCookieMeta("a=", "a=0:");
        DoTestPrintSetCookieMeta("a=;", "a=0:;");
        DoTestPrintSetCookieMeta("a=b", "a=1:a");
        DoTestPrintSetCookieMeta("a=bbbaaa", "a=6:a");
        DoTestPrintSetCookieMeta("\7=\7\xFF\xFF", "\\7=3:\\7\\xFF\\xFF");
        DoTestPrintSetCookieMeta(
            "a=bbbaaa; Secure; HttpOnly; SameSite=Lax; Domain=foo.bar; Path=/xxx; Expires=Wed, 21 Oct 2015 07:28:00 GMT; Max-Age=321",
            "a=6:a; Secure; HttpOnly; SameSite=Lax; Domain=foo.bar; Path=/xxx; Expires=Wed, 21 Oct 2015 07:28:00 GMT; Max-Age=321"
        );
    }
}
