#pragma once

#include <balancer/kernel/cookie/cookie.h>
#include <balancer/kernel/cookie/set_cookie.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/generic/variant.h>
#include <util/generic/vector.h>

namespace NSrvKernel::NCookie {

    void TestParse(TString input, TSetCookie::TParseResult result, TMaybe<TString> expectedRender = Nothing());

    void TestRender(const TSetCookie& c, TStringBuf expected);

    using TCookieVec = TVector<TNameValue>;

    void TestEveryCookieKV(const TStringBuf cookie, const TCookieVec& expected);
}
